//=============================================================================
// flashlight
//=============================================================================
class Respawnables_Pickup_Flashlight extends Pickup;

var FlashLightBeam s;
var float TimeChange;
var Vector HitNormal,HitLocation,EndTrace,StartTrace,X,Y,Z,NewHitLocation;

auto state Pickup
{	
	function Touch( actor Other )
	{
		local Inventory Copy;
		if ( ValidTouch(Other) ) 
		{
			Copy = SpawnCopy(Pawn(Other));
			if (bActivatable && Pawn(Other).SelectedItem==None) 
				Pawn(Other).SelectedItem=Copy;
			if (bActivatable && bAutoActivate && Pawn(Other).bAutoActivate) Copy.Activate();

			Pawn(Other).ClientMessage(PickupMessage, 'Pickup');

			PlaySound (PickupSound,,2.0);	
			Pickup(Copy).PickupFunction(Pawn(Other));
		}
	}

	function BeginState()
	{
		Super.BeginState();
		NumCopies = 0;
	}
}

function bool HandlePickupQuery( inventory Item )
{
	if (item.class == class) 
	{
		if (bCanHaveMultipleCopies) 
		{   // for items like Artifact
			NumCopies++;


			Pawn(Owner).ClientMessage(item.PickupMessage, 'Pickup');

			Item.PlaySound (Item.PickupSound,,2.0);
			Item.SetRespawn();
		}
		else if ( bDisplayableInv ) 
		{		
			if ( Charge<Item.Charge )	
				Charge= Item.Charge;

			Pawn(Owner).ClientMessage(item.PickupMessage, 'Pickup');

			Item.PlaySound (item.PickupSound,,2.0);
			Item.SetReSpawn();
		}
		return true;				
	}
	if ( Inventory == None )
		return false;

	return Inventory.HandlePickupQuery(Item);
}

function Activate()
{
	if( bActivatable )
	{
	Pawn(Owner).ClientMessage(PickupMessage);	
	GoToState('Activated');
	}
}

state Activated
{
	function endstate()
	{
		if (s!=None) s.Destroy();
		bActive = false;		
	}
	
	function Tick( float DeltaTime )
	{
		TimeChange += DeltaTime*10;
		if (TimeChange > 1) {
			if ( s == None )
			{
				//UsedUp();
				return;
			}		
			Charge -= int(TimeChange);
			TimeChange = TimeChange - int(TimeChange);
		}
		
		if (s == None) Return;

		if ( Pawn(Owner) == None )
		{
			s.Destroy();
			//UsedUp();
			return;		
		}
		
		/*
		if (Charge<-0) {
			s.Destroy();
			Pawn(Owner).ClientMessage(ExpireMessage);		
			//UsedUp();		
		}
		
		if (Charge<400) s.LightBrightness=byte(Charge*0.6+10);
		*/
		
		GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);	
		EndTrace = Pawn(Owner).Location + 10000* Vector(Pawn(Owner).ViewRotation);
		Trace(HitLocation,HitNormal,EndTrace,Pawn(Owner).Location, True);
		s.SetLocation(HitLocation-vector(Pawn(Owner).ViewRotation)*64);
//		s.LightRadius = fmin(Vsize(HitLocation-Pawn(Owner).Location)/200,14) + 2.0;
	}
	
	function BeginState()
	{
		TimeChange = 0;
		Owner.PlaySound(ActivateSound);		
		GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);	
		EndTrace = Pawn(Owner).Location + 10000* Vector(Pawn(Owner).ViewRotation);
		Trace(HitLocation,HitNormal,EndTrace,Pawn(Owner).Location+Y*17);
		s = Spawn(class'FlashLightBeam',Owner, '', HitLocation+HitNormal*40);
		s.LightHue = LightHue;
		s.LightRadius = LightRadius;		
		if (Charge<400) s.LightBrightness=byte(Charge*0.6+10);	
		if (s==None) GoToState('DeActivated');	
	}
	
Begin:
}

state DeActivated
{
Begin:
	s.Destroy();
	Owner.PlaySound(DeActivateSound);
}

defaultproperties
{
     ExpireMessage="You turned off your flashlight."
     bActivatable=True
     bDisplayableInv=True
     PickupMessage="You turned on your flashlight"
     RespawnTime=40.000000
     PickupViewMesh=LodMesh'UnrealShare.Flashl'
     Charge=800
     PickupSound=Sound'UnrealShare.Pickups.GenPickSnd'
     ActivateSound=Sound'UnrealShare.Pickups.FSHLITE1'
     DeActivateSound=Sound'UnrealShare.Pickups.FSHLITE2'
     Icon=Texture'UnrealShare.Icons.I_Flashlight'
     RemoteRole=ROLE_DumbProxy
     Mesh=LodMesh'UnrealShare.Flashl'
     AmbientGlow=96
     CollisionRadius=22.000000
     CollisionHeight=4.000000
     LightBrightness=100
     LightHue=33
     LightSaturation=187
     LightRadius=7
}
